/****************************************************************************
*
*    Copyright 2012 - 2024 Vivante Corporation, Santa Clara, California.
*    All Rights Reserved.
*
*    Permission is hereby granted, free of charge, to any person obtaining
*    a copy of this software and associated documentation files (the
*    'Software'), to deal in the Software without restriction, including
*    without limitation the rights to use, copy, modify, merge, publish,
*    distribute, sub license, and/or sell copies of the Software, and to
*    permit persons to whom the Software is furnished to do so, subject
*    to the following conditions:
*
*    The above copyright notice and this permission notice (including the
*    next paragraph) shall be included in all copies or substantial
*    portions of the Software.
*
*    THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND,
*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
*    IN NO EVENT SHALL VIVANTE AND/OR ITS SUPPLIERS BE LIABLE FOR ANY
*    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
*    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
*    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

#ifndef __CL_EXT_VIV_H
#define __CL_EXT_VIV_H

#include <CL/cl.h>
#include <CL/cl_platform.h>

#ifdef __cplusplus
extern "C" {
#endif

/* address or size is not aligned */
#define CL_NOT_ALIGNED          -1143


/********************************************************************
* cl_vivante_device_attribute_query
********************************************************************/
#define CL_MEM_USE_UNCACHED_HOST_MEMORY_VIV         (1 << 28)

/* for CL_MEM_USE_HOST_PHYSICAL_ADDR_VIV, application must make
   sure the physical address passed in is a host physical address that GPU
   can access. and driver can access this memory
   limitation:
       alignment 256 bytes
       NOT support clEnqueueMapBuffer and clEnqueueMapImage
       clEnqueueRead(Buffer|Image), clEnqueueWrite(Buffer|Image) for data synchronization
*/
#define CL_MEM_USE_HOST_PHYSICAL_ADDR_VIV           (1 << 29)


/* external sram */
#define CL_MEM_ALLOC_FROM_EXTERNAL_SRAM_VIV         (((cl_mem_flags)1) << 63)
/* return type: size_t[] */
#define CL_DEVICE_EXTERNAL_SRAM_SIZE_VIV            0x4280
/* return type: cl_uint */
#define CL_DEVICE_VIDMEM_CHANNEL_COUNT_VIV          0x4281


/* properties for clCreateBufferWithProperties and clCreateImageWithProperties */
/* property value type: cl_uint */
#define CL_DEVICE_ALLOC_FROM_EXTSRAM_INDEX_VIV      0x4282
/* property value type: cl_uint */
#define CL_DEVICE_ALLOC_FROM_VIDMEM_INDEX_VIV       0x4283

#ifdef __cplusplus
}
#endif

#endif
